import { Controller } from "@hotwired/stimulus";

export default class extends Controller {
  static targets = ["content", "collapsedIcon", "expandedIcon"];
  static values = { open: Boolean };

  connect() {
    // Set initial state based on data attribute
    this.isOpen = this.openValue;
    this.updateDisplay();
  }

  toggle() {
    this.isOpen = !this.isOpen;
    this.updateDisplay();
  }

  updateDisplay() {
    const content = this.contentTarget;
    const collapsedIcon = this.collapsedIconTarget;
    const expandedIcon = this.expandedIconTarget;

    if (this.isOpen) {
      // Show content
      content.style.maxHeight = content.scrollHeight + "px";
      content.style.opacity = "1";
      content.setAttribute("data-state", "open");

      // Fade to expanded icon
      collapsedIcon.style.opacity = "0";
      expandedIcon.style.opacity = "1";

      // Update container state
      this.element.setAttribute("data-state", "open");
    } else {
      // Hide content
      content.style.maxHeight = "0";
      content.style.opacity = "0";
      content.setAttribute("data-state", "closed");

      // Fade to collapsed icon
      collapsedIcon.style.opacity = "1";
      expandedIcon.style.opacity = "0";

      // Update container state
      this.element.setAttribute("data-state", "closed");
    }
  }
}
